﻿//*******************************************************************************
//このプログラムは、計測器に接続してコマンドの送受信を行います。
//コマンドの欄に送信したいコマンドを入力し、[送受信]ボタンを押すと送信されます。
//応答があるコマンド（?が含まれるコマンド）の場合は、テキストボックスに応答が表示されます。
//
//ナショナルインスツルメンツ(株)のNI-488.2 .NET Frameworkに含まれる
//NationalInstruments.CommonとNationalInstruments.NI4882をプロジェクトに追加し、
//参照設定しています。
//
//動作確認環境
//   Microsoft Visual Studio Professional 2017
//   Microsoft.NET Framework 4.7
//*******************************************************************************

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Sample
{
    public partial class Form1 : Form
    {
        private GPIB_NI comm;

        //フォームが開かれたときの処理
        public Form1()
        {
            InitializeComponent();
            // ボタンとテキストボックスの有効/無効の処理
            Button1.Enabled = true;
            Button2.Enabled = false;
            Button3.Enabled = false;
            TextBox1.Enabled = true;
            TextBox2.Enabled = true;
            TextBox3.Enabled = false;
            TextBox4.Enabled = false;
            TextBox5.ReadOnly = true;
        }

        // 「接続」ボタンを押したときの処理
        private void Button1_Click(object sender, EventArgs e)
        {
            // GPIBオブジェクト生成
            comm = new GPIB_NI();

            // 接続
            if (comm.OpenInterface(TextBox1.Text, TextBox2.Text) == false)
            {
                return;
            }

            // ボタンとテキストボックスの有効/無効の処理
            Button1.Enabled = false;
            Button2.Enabled = true;
            Button3.Enabled = true;
            TextBox1.Enabled = false;
            TextBox2.Enabled = false;
            TextBox3.Enabled = true;
            TextBox4.Enabled = true;
        }

        // 「切断」ボタンを押したときの処理
        private void Button2_Click(object sender, EventArgs e)
        {
            // 切断
            comm.CloseInterface();

            // ボタンとテキストボックスの有効/無効の処理
            Button1.Enabled = true;
            Button2.Enabled = false;
            Button3.Enabled = false;
            TextBox1.Enabled = true;
            TextBox2.Enabled = true;
            TextBox3.Enabled = false;
            TextBox4.Enabled = false;
        }

        // 「送受信」ボタンを押したときの処理
        private void Button3_Click(object sender, EventArgs e)
        {
            Button3.Enabled = false;

            TextBox5.AppendText("<< " + TextBox3.Text + "\r\n");                        // 送信データログ出力
            comm.SendQueryMsg(TextBox3.Text, Convert.ToInt64(TextBox4.Text) * 1000);    // 送受信
            if (TextBox3.Text.Contains("?") == true)                                    // コマンドに?が含まれる場合
            {
                TextBox5.AppendText(">> " + comm.MsgBuf + "\r\n");                      // 受信データログ出力
            }

            Button3.Enabled = true;
        }

        // 「クリア」ボタンを押したときの処理
        private void Button4_Click(object sender, EventArgs e)
        {
            // テキストボックスの消去
            TextBox5.Clear();
        }

    }
}
